<?php
require_once('SuperFacturaAPI/api.php');

// 1) Generar arreglo con datos del DTE

$datos = [
	'Encabezado' => [
		'IdDoc' => [
			'TipoDTE' => 33,
			// 'FchEmis' => '2015-01-01', // Opcional
		],
		'Emisor' => [
			'RUTEmisor' => '99581150-2',
			// Los dems datos sern agregados por SuperFactura
		],
		'Receptor' => [
			'RUTRecep' => '1-9',
			'RznSocRecep' => 'Test',
			'GiroRecep' => 'Giro',
			'DirRecep' => 'Direccin',
			'CmnaRecep' => 'Comuna',
			'CiudadRecep' => 'Ciudad',
		],
		// 'Totales' ser agregado por SuperFactura
	],
	'Detalles' => [
		[
			// 'NroLinDet' ser agregado por SuperFactura
			'NmbItem' => 'Item 1',
			'DscItem' => 'Descripcin del item 1',
			'QtyItem' => 3,
			'UnmdItem' => 'KG',
			'PrcItem' => 100,
		],
		[
			'NmbItem' => 'Item 2',
			'DscItem' => 'Descripcin del item 2',
			'QtyItem' => 5,
			'UnmdItem' => 'KG',
			'PrcItem' => 65,
		],
	],
];

// 2) Usar API para generar y enviar el DTE al SII

$api = new SuperFacturaAPI('usuario@cliente.cl', 'mypassword');
$resultado = $api->SendDTE($datos, 'cer'); // 'pro' = ambiente produccin y 'cer' = ambiente certificacin

// 3) Procesar salida de la API

if($resultado['ok']) {
	die("Ok. Folio: {$resultado['folio']}");

} else {
	die('Error');
}
